/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: CifXDeviceBase.cpp $
   Last Modification:
    $Author: Robert $
    $Modtime: 27.07.06 13:29 $
    $Revision: 3195 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    CifX Device base class, for accessing System Device and channel via the same functions
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        28.06.2006  MT       initial version
 
**************************************************************************************/

#include "StdAfx.h"
#include ".\cifxdevicebase.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// \file CifxDeviceBase.cpp
/// CifX Device base class, for accessing System Device and channel via the same functions
///////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
/// Constructor
///   \param ptBoardInfo    Pointer to board information from driver
///   \param ptChannelInfo  Pointer to channel information from driver
/////////////////////////////////////////////////////////////////////////////
CCifXDeviceBase::CCifXDeviceBase(BOARD_INFORMATION* ptBoardInfo, CHANNEL_INFORMATION* ptChannelInfo)
{
  if(ptBoardInfo)
    m_tBoardInfo = *ptBoardInfo;
  else
    ZeroMemory(&m_tBoardInfo, sizeof(m_tBoardInfo));

  if(ptChannelInfo)
    m_tChannelInfo = *ptChannelInfo;
  else
    ZeroMemory(&m_tChannelInfo, sizeof(m_tChannelInfo));
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CCifXDeviceBase::~CCifXDeviceBase(void)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Get the device specific properties
///   \return Array of all property/value pairs
/////////////////////////////////////////////////////////////////////////////
std::vector<CCifXDeviceBase::PROPERTY_LIST> CCifXDeviceBase::GetDescription(void)
{
  std::vector<CCifXDeviceBase::PROPERTY_LIST> cvList;

  PROPERTY_LIST tList;

  tList.csProperty = _T("Physical Address");
  tList.csValue.Format(_T("0x%08X"), m_tBoardInfo.ulPhysicalAddress);
  cvList.push_back(tList);

  tList.csProperty = _T("Interrupt");
  tList.csValue.Format(_T("%u"), m_tBoardInfo.ulIrqNumber);
  cvList.push_back(tList);

  if(CIFX_NO_ERROR != m_tBoardInfo.lBoardError)
  {
    tList.csProperty = _T("Board Error (Code)");
    tList.csValue.Format(_T("0x%08X"), 
                         m_tBoardInfo.lBoardError);
    cvList.push_back(tList);

    tList.csProperty = _T("Board Error (Descr.)");
    tList.csValue.Format(_T("%s"), 
                         GetErrorDescription(m_tBoardInfo.lBoardError));
    cvList.push_back(tList);

  } else
  {
    tList.csProperty = _T("Device Number");
    tList.csValue.Format(_T("%u"), m_tBoardInfo.tSystemInfo.ulDeviceNumber);
    cvList.push_back(tList);

    tList.csProperty = _T("Serial Number");
    tList.csValue.Format(_T("%u"), m_tBoardInfo.tSystemInfo.ulSerialNumber);
    cvList.push_back(tList);
  }

  tList.csProperty = _T("Physical DPM Size");
  tList.csValue.Format(_T("%u"), m_tBoardInfo.ulDpmTotalSize);
  cvList.push_back(tList);

  return cvList;
}

/////////////////////////////////////////////////////////////////////////////
/// Get Channel's Property/Value pairs for the Channel/Device
///   \return Property/Value pairs (strings)
/////////////////////////////////////////////////////////////////////////////
CCifXDeviceBase::PROPERTY_VECTOR CCifXDeviceBase::GetDriverInformation()
{
  DRIVER_INFORMATION tDriverInfo = {0};

  long lRet = xDriverGetInformation(NULL, 
                                    sizeof(tDriverInfo), 
                                    &tDriverInfo);
  PROPERTY_VECTOR cvRet;

  if(CIFX_NO_ERROR == lRet)
  {
    PROPERTY_LIST tList;

    tList.csProperty = _T("Driver Version");
    tList.csValue.Empty();
    
    for(int iIdx = 0; iIdx < sizeof(tDriverInfo.abDriverVersion) / sizeof(tDriverInfo.abDriverVersion[0]); ++iIdx)
      tList.csValue.AppendFormat(_T("%c"), (char)tDriverInfo.abDriverVersion[iIdx]);
    cvRet.push_back(tList);

    tList.csProperty = _T("Board Count");
    tList.csValue.Format(_T("%u"), tDriverInfo.ulBoardCnt);
    cvRet.push_back(tList);
  }
  
  return cvRet;
}
